package p15_kolekcje.z_zbierz_dane;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

// Lista:
// - zachowuje kolejność elementów i jest sens mówić o indeksach (numerach pozycji)
// - może zawierać powtórzenia
// - nie wymaga deklarowania z góry liczby elementów; operacja add prawie zawsze potrafi dodać kolejny element na końcu
// - List jest interfejsem; istnieje wiele implementacji listy,
//   z czego zdecydowanie najczęściej używaną jest ArrayList
public class P3_Lista {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        List<String> lista = new ArrayList<>();

        // Jeśli ma zawierać od razu elementy, to od Javy 9 pisze się tak
        // (gdy chcemy mieć listę zdolną do późniejszych modyfikacji)
        // List<String> lista = new ArrayList<>(List.of("Ala", "Ela", "Ola"));
        // List<String> lista = new ArrayList<>(List.of(tablica));
        // a w starszych wersjach:
        // List<String> lista = new ArrayList<>(Arrays.toList("Ala", "Ela", "Ola"));
        // List<String> lista = new ArrayList<>(Arrays.toList(tablica));
        // Takie coś: List<String> lista = List.of("Ala", "Ela", "Ola");
        // utworzy listę "niemutowalną", tylko do odczytu.

        while(true) {
            System.out.print("Podaj kolejne imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            lista.add(imie);
            // jbc, to tak można wywołać metodę a poziomu AL: ((ArrayList<String>)lista).ensureCapacity(50);
        }

        System.out.println("Liczba elementów: " + lista.size());
        System.out.println("Wszystkie imiona:");
        System.out.println(lista);

        // Tablica i wszystkie typy kolekcji pozwalają na używanie pętli "for-each".
        for(String imie : lista) {
            System.out.print("; witaj " + imie);
        }
        System.out.println();

        // Podobnie, jak w przypadku tablic, elementy list także mają ustalony numer pozycji
        // od 0 do size-1. Za pomocą get można odczytać element o podanym numerze,
        // a set(i, nowa_wartosc) zmienia wartość elementu na nową.
        // - ArrayList daje szybki dostęp do elementów o określonym numerze
        // - ale ogólnie nie wszystkie listy mają ten dostęp szybki; dla LinkedList operacje get/set działają wolno
        while(true) {
            System.out.print("Podaj nr pozycji: ");
            int pozycja = scanner.nextInt();
            scanner.nextLine();
            if(pozycja == -1) {
                break;
            }
            try {
                String imie = lista.get(pozycja);
                System.out.println("Osoba nr " + pozycja + " to " + imie);
            } catch (Exception e) {
                System.out.println(e);
            }
        }
    }

}
