package emps.v2_obiektowo;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie2a {
	// W tej wersji używam operacji getOrDefault (od Java 8), dzięki czemu nie trzeba pisać if

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		Map<String, Integer> sumy = new TreeMap<>();
		Map<String, Integer> ilosci = new TreeMap<>();
		for(Employee emp : emps) {
			final String jobTitle = emp.getJobTitle();
            sumy.put(jobTitle, sumy.getOrDefault(jobTitle, 0) + emp.getSalary());
			ilosci.put(jobTitle, ilosci.getOrDefault(jobTitle, 0) + 1);
		}

		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |%n", job, ile, srednia);
		}
	}

}
