package p02_obiekty;

import java.time.LocalDate;
import java.time.Period;

public class Osoba {
    private String imie;
    private String nazwisko;
    private final LocalDate dataUrodzenia;

    public Osoba(String imie, String nazwisko, LocalDate dataUrodzenia) {
        if(nazwisko == null) {
            throw new NullPointerException("nazwisko is null");
        }
        this.imie = imie;
        this.nazwisko = nazwisko;
        this.dataUrodzenia = dataUrodzenia;
    }
    
    public Osoba(String imie, String nazwisko, String dataUrodzenia) {
        this(imie, nazwisko, LocalDate.parse(dataUrodzenia));
    }

    public String getImie() {
        return imie;
    }

    public String getNazwisko() {
        return nazwisko;
    }

    public int getWiek() {
        Period p = Period.between(dataUrodzenia, LocalDate.now());
        return p.getYears();
    }

    public LocalDate getDataUrodzenia() {
        return dataUrodzenia;
    }

    public void setImie(String imie) {
        this.imie = imie;
    }

    public void setNazwisko(String nazwisko) {
        if(nazwisko == null) {
            throw new NullPointerException("nazwisko is null");
        }
        this.nazwisko = nazwisko;
    }

    @Override
    public String toString() {
        return "Osoba [imie=" + imie + ", nazwisko=" + nazwisko + ", dataUrodzenia=" + dataUrodzenia + ", wiek="
                + getWiek() + "]";
    }

}
