package sprzedaz;

import java.math.BigDecimal;
import java.time.LocalDate;

/* Record to taka specjalna wersja klasy (podobnie jak enum jest specjalną wersją klasy w języku Java),
która zawiera rzeczy generowane automatycnzie na podstawie parametrów podanych w nawiasach.
Automatycznie tworzone są:
- pola private final
- konstruktor z takimi parametrami
- metody dostępowe służące do odczytu. Nie mają one w nazwie "get", tylko nazywają się tak samo jak pola
- toString, equals i hashCode (przypominające standardowe implementacje generowane przez IDE)
*/
public record Transakcja(
        LocalDate data,
        String miasto,
        String sklep,
        String kategoria,
        String towar,
        BigDecimal cena,
        int sztuk) {
    
    // W rekordach można definiować dodatkowe metody. Duży sens mają takie, które zwracają wyniki obliczone na podstawie wartości pól
    public BigDecimal wartosc() {
        return cena.multiply(BigDecimal.valueOf(sztuk));
    }

    public double wartoscDouble() {
        return wartosc().doubleValue();
    }

    public int rok() {
        return data.getYear();
    }
}
