package pan_tadeusz;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

public class P03_WypiszWszystkieSlowa {

    public static void main(String[] args) {
        try(Scanner scanner = new Scanner(new File("pan_tadeusz.txt"))) {
            // ustawienie "delimitera" jako wyrażenia regularnego,
            // aby pomijać znaki interpunkcyjne
            // scanner.useDelimiter(" ");
            // scanner.useDelimiter("\\s+"); // każdy ciąg "białych znaków" - domyślne ustawienie Scannera
            // scanner.useDelimiter("[\\s,.\\-—!?()*…«»;:]+"); // ciąg znaków wymienionych w nawiasach kwadratowych (niektóre wymagają poprzedzenia \\)
            scanner.useDelimiter("[^\\p{L}\\d]+"); // ciąg znaków niebędących literami ani cyframi
            int ile = 0;
            while(scanner.hasNext()) {
                String slowo = scanner.next();
                System.out.println("["+slowo+"]");
                ile++;
            }
            System.out.println("Lacznie slow: " + ile);            
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

}
