package p16_streamy.c_przeglad_operacji;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class C13_MultiMap {
	
	public static void main(String[] args) {
		System.out.println("Elementy strumienia wejściowego:");
		Stream.of(1, 3, 0, 5)
				.forEach(x -> System.out.print(x + " | "));
		System.out.println();

		// W mapMulti funkcja powinna przyjąć element strumienia wejściowego i wykonać odpowiednią ilość akcji
		// na przekazanym do niej obiekcie Consumer.
		// Wynikiem jest strumień składający się z tych wartości, które za pomocą accept zostały dostarczone do Consumera.
		// Istotne jest, że wynikowy strumień może zawierać mniej lub więcej elementów, niż wejściowy (podobnie jak we flatMap).
		System.out.println("mapMulti");
		Stream.of(1, 3, 0, 5)
				.mapMulti((n, c) -> {
					for (int i = 1; i <= n; i++) {
						c.accept(i);
					}
				})
				.forEach(x -> System.out.print(x + " | "));
		System.out.println("=================");
		// przykład mapowania 1→1 za pomocą mapMulti (wiadomo, że dałoby się zwykłym map)
		Stream.of(1, 3, 0, 5)
				.mapMulti((n, c) -> c.accept(n*n))
				.forEach(x -> System.out.print(x + " , "));
	}

}
