package p06_lambdy;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class KolekcjaFunkcji {
    static void main() {
        Map<String, FunkcjaLiczbowa> funkcje = new LinkedHashMap<>();
        funkcje.put("inc", x -> x+1);
        funkcje.put("dec", x -> x-1);
        funkcje.put("sqr", x -> x*x);
        funkcje.put("sqrt", Math::sqrt);
        funkcje.put("razy2", x -> 2*x);
        funkcje.put("razy10", x -> 10*x);

        while(true) {
            String f = IO.readln("Podaj funkcje: ");
            if (f.isEmpty()) break;
            double arg = Double.parseDouble(IO.readln("Podaj liczbę: "));

            FunkcjaLiczbowa funkcjaLiczbowa = funkcje.get(f);
            if (funkcjaLiczbowa == null) {
                System.out.println("Nieznana funkcja");
                continue;
            }
            double wynik = funkcjaLiczbowa.oblicz(arg);
            System.out.printf("%s(%s) = %s\n", f, arg, wynik);
        }
        System.out.println();

        funkcje.forEach((nazwa, funkcja) -> {
            double arg = 100;
            System.out.printf("%s(%s) = %s\n", nazwa, arg,funkcja.oblicz(arg));
        });
    }
}
