package p04_watki.dodatkowe;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PuleWatkow1 {
    // Wiele zadań typu Runnable i jedno typu Callable

    public static void main(String[] args) {
        System.out.println("Początek main");

        Future<String> future = null;

        try(ExecutorService executorService = Executors.newFixedThreadPool(4)) {
            for(int i = 0; i < 10; i++) {
                var numer = i;
                executorService.submit(() -> {
                    System.out.println("Runnable " + numer + " , wątek " + Thread.currentThread().getName());
                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {
                    }
                });
            }

            future = executorService.submit(() -> "wynik pierwszego callable z wątku " + Thread.currentThread().getName());
            System.out.println("Wsystkie zadania zlecone.");

            System.out.println("Stan obiektu Future: " + future.isDone());
            System.out.println(future);
        }
        System.out.println("Pula zamknięta");

        System.out.println("Teraz odczytuję wynik z Future");
        try {
            System.out.println(future.get());
        } catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        System.out.println("Koniec main");
    }
}
