package emps.v3_funkcyjnie;

import java.util.List;

public class F9_Podwyzka {
	// Generalnie strumienie pozwalają nam na "odczyt", a nie służą modyfikacji listy / zbioru itp.
	// Jeśli jednak obiekty zawarte w liście są "mutowalne", to za pośrednictwem strumienia MOŻNA zmodyfikować te obiekty.

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");

		emps.stream()
			.filter(emp -> "Programmer".equals(emp.getJobTitle()))
			.forEach(emp -> emp.setSalary(emp.getSalary() + 3333));

		emps.forEach(emp -> System.out.println(emp.getFirstName() + " " + emp.getLastName() + " (" + emp.getJobTitle() + ") : " + emp.getSalary()));

		ObslugaCSV.zapisz(emps, "zmodyfikowany2.csv");
	}

}
