package sprzedaz.wydajnosc;

import java.io.File;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import sprzedaz.MaszynaWczytujaca1;
import sprzedaz.Transakcja;

/* Korzystamy z przygotowanej metody w MaszynaWczytujaca1 - wersja z listą */
public class CzytajILicz5a {

	static void calaRobota() {
		try {
			File plik = new File(WyczarujPliki.DUZY_PLIK);
			Map<String, BigDecimal> sumyDouble = MaszynaWczytujaca1.wczytaj(plik)
			    .stream()
				.collect(Collectors.groupingBy(Transakcja::miasto,
					Collectors.mapping(Transakcja::wartosc,
						Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));

			sumyDouble.forEach((k, v) -> System.out.printf(Locale.US, "%12s - %12.2f\n", k, v));
			System.out.println();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		Pomiary.zmierzCzasDzalania(CzytajILicz5a::calaRobota);
		Pomiary.wypiszPamiec();
	}

}
