package sprzedaz;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie7 {
    public static void main(String[] args) {
        List<Transakcja> lista = MaszynaWczytujaca1.wczytaj();

        // W tej wersji do kolektora groupingBy przekazujemy kolejny parametr,
        // też kolektor mówiący "co robić każdą grupą".
        Map<String, Double> sumy = lista.stream()
                .collect(Collectors.groupingBy(Transakcja::miasto,
                        Collectors.summingDouble(Transakcja::wartoscDouble)));

        // sumy.forEach((miasto, suma) -> System.out.printf("%-10s : %12s%n", miasto, suma));
        sumy.forEach((miasto, suma) -> System.out.printf("%-10s : %12.2f%n", miasto, suma));
    }
}
