package p16_streamy.c_przeglad_operacji;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class C12_FlatMap {
	
	static List<Integer> generuj(int ilosc) {
		List<Integer> lista = new ArrayList<>();
		for(int i = 1; i <= ilosc; i++) {
			lista.add(i);
		}
		return lista;
	}
	
	static Stream<Integer> generujStrumien(int ilosc) {
		return generuj(ilosc).stream();
	}
	
	static IntStream generujStrumienIntow(int ilosc) {
		return generujStrumien(ilosc).mapToInt(Integer::intValue);
	}
	

	public static void main(String[] args) {
		System.out.println(generuj(1));
		System.out.println(generuj(3));
		System.out.println(generuj(0));
		System.out.println(generuj(5));
		System.out.println();
		
		System.out.println("Elementy strumienia wejściowego:");
		Stream.of(1, 3, 0, 5)
			.forEach(x -> System.out.print(x + " | "));
		System.out.println();
		System.out.println();

		// W zwykłym map wynikowy strumień zawiera tyle samo elementów, co wejściowy.
		// Jeśli funkcja mapuje wartości na kolekcje - wynikiem jest strumień kolekcji.
		// Jeśli funkcja mapuje wartości na strumienie - wynikiem jest strumień strumieni.
		System.out.println("Zwykłe mapowanie:");
		Stream.of(1, 3, 0, 5)
			.map(C12_FlatMap::generuj)
			.forEach(x -> System.out.print(x + " | "));
		System.out.println();


		Stream.of(1, 3, 0, 5)
			.map(x -> C12_FlatMap.generuj(x).stream())
			.forEach(x -> System.out.print(x + " | "));
		System.out.println();
		System.out.println();

		// We flatMap funkcja powinna mapować wartość na strumień, a wynikiem jest konkatenacja wynikowych strumieni.
		// Daje to możliwość mapowania pojedynczego elementu wejściowego na dowolną liczbę elementóœ wynikowych:
		// zero (!), jeden, dowolną skończoną liczbę, a nawet nieskońćzoność.
		// Funkcja mapuje wartości na strumienie - wynikiem jest strumień wartości.
		System.out.println("Płaskie mapowanie:");
		Stream.of(1, 3, 0, 5)
			.flatMap(x -> C12_FlatMap.generuj(x).stream())
			.forEach(x -> System.out.print(x + " | "));
		System.out.println();
		System.out.println();

		Stream.of(1, 3, 0, 5)
			.flatMap(C12_FlatMap::generujStrumien)
			.forEach(x -> System.out.print(x + " | "));
		System.out.println();
		System.out.println();
		
		int suma = Stream.of(1, 3, 5)
			.flatMapToInt(C12_FlatMap::generujStrumienIntow)
			.sum();
		System.out.println(suma);
	}
}

