package p09_switch;

import javax.swing.JOptionPane;

public class DniTygodnia4 {
    // Nawet w oparciu o "stary styl" switchów możemy zdefiniować oddzielną funkcję,
    // która mapuje numery dni tygodnia na ich nazwy.
    // switch umieszczony w oddzielnej funkcji zaczyna wyglądać całkiem "zgrabnie".
    
    static String nazwaDniaTygodnia(int numer) {
        switch(numer) {
        case 1: return "poniedziałek";
        case 2: return "wtorek";
        case 3: return "środa";
        case 4: return "czwartek";
        case 5: return "piątek";
        case 6: return "sobota";
        case 7: return "niedziela";
        default: throw new IllegalArgumentException("Niepoprawny numer " + numer);
        }
    }
    
    public static void main(String[] args) {
        try {
            int numer = Integer.parseInt(JOptionPane.showInputDialog("Podaj numer dnia tygodnia"));
            String nazwa = nazwaDniaTygodnia(numer);
            JOptionPane.showMessageDialog(null, "To jest " + nazwa);
        } catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Błąd", JOptionPane.ERROR_MESSAGE);            
        }
    }

}
