package p05_interfejsy;

import java.util.List;
import java.util.stream.Collectors;

public class Program1 {
    public static void main(String[] args) {
        Osoba osoba = new Osoba("Ala", "Kowalska", "Marszałkowska 123, Warszawa");
        Firma firma = new Firma("ALX", "1231238899", "Jasna 14/16a, Warszawa");

        System.out.println(osoba.dajAdres());
        System.out.println(firma.dajAdres());
        System.out.println(firma.nazwa());
        System.out.println(firma);

        // Od Java 8 obiekty zgodne z interfejsem można tworzyć za pomocą wyrażeń lambda
        Adresowalny lambda = () -> "Adres lambdowy";
        System.out.println(lambda);

        // A od początku języka Java można stosować "klasy anonimowe"
        Adresowalny anonim = new Adresowalny() {
            public String dajAdres() {
                return "Adres anonimowy";
            }
        };

        System.out.println();
        List<Adresowalny> adresy = List.of(osoba, firma, lambda);
        for(var obiekt : adresy) {
            System.out.println(obiekt.dajAdres());
        }
        System.out.println();

        String html = adresy.stream()
                .map(Adresowalny::adresJakoHtml)
                .collect(Collectors.joining("\n", "<html><body>\n", "\n</body></html>"));
        System.out.println(html);

        // javax.swing.JOptionPane.showMessageDialog(null, html);
    }

}
