package emps.v3_funkcyjnie;

import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;

public class F3_SredniaWszystkich {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");

		/*
		// Uwaga, to nie zadziała; to nie tak się robi.
		// Wewnątrz wyrażeń lambda nie wolno modyfikować zmiennych lokalnych zdefiniowanych na zewnątrz tych wyrażeń.
		// (generalnie - nie wolno uzywać zmiennych, które nie są "effectively final"
		double suma = 0;
		int ile = 0;
		emps.forEach(emp -> {
			suma += emp.getSalary();
			ile++;
		});
		*/

		// Można użyć gotowych dedykowanych rozwiązań
		// 1) IntStream (istnieją jeszcze LongStream oraz DoubleStream; nie istnieje FloatStream)
		OptionalDouble srednia1 = emps.stream()
			.mapToInt(Employee::getSalary)
			.average();
		System.out.println(srednia1);
		// Gdyby strumień był pusty, to wynikiem byłby pusty Optional.
		// Aby dostać się do samej liczby, najelepiej zrobić to tak (w razie braku danych podstawi 0):

		double srednia2 = emps.stream()
			.mapToInt(Employee::getSalary)
			.average()
			.orElse(0);
		System.out.println(srednia2);

		// 2) odpowiedni Collector, czyli taka maszynka, która zbiera dane i na końcu zwraca wynik
		Double srednia3 = emps.stream().collect(Collectors.averagingInt(Employee::getSalary));
		System.out.println(srednia3);
	}

}
