package sprzedaz.wydajnosc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import sprzedaz.Transakcja;

// Wersja wprowadzająca pomysł puli obiektów dla klas BigDecimal i LocalDate - zmniejszenie zajętości pamięci i drobna poprawa czasu wczytywania.

// W puli obiektów chodzi o to, aby nie tworzyć oddzielnych obiektów dla każdego wiersza danych,
// ale użyć referencji do obiektu, który został utworzony wcześniej, gdy w późniejszym wierszu pojawia się taka sama wartość
// daty lub ceny. Taka technika może dać duże oszczędności pamięci, jeśli w danych wejściowych jest dużo powtórzeń.
public class WczytajSprzedaz4 {

	static List<Transakcja> wczytaj(File plik) throws IOException {
		Map<String, LocalDate> pulaDat = new HashMap<>();
		Map<String, BigDecimal> pulaCen = new HashMap<>();

		List<Transakcja> lista = new ArrayList<>();
		try(BufferedReader reader = Files.newBufferedReader(plik.toPath())) {
			String linia = reader.readLine();
			while ((linia = reader.readLine()) != null) {
				String[] pola = linia.split(",");

				LocalDate data = pulaDat.get(pola[0]);
				if(data == null) {
					data = LocalDate.parse(pola[0]);
					pulaDat.put(pola[0], data);
				}

				BigDecimal cena = pulaCen.get(pola[5]);
				if(cena == null) {
					cena = new BigDecimal(pola[5]);
					pulaCen.put(pola[5], cena);
				}

				String miasto = pola[1];
				String sklep = pola[2];
				String kategoria = pola[3];
				String towar = pola[4];
				int sztuk = Integer.parseInt(pola[6]);

				Transakcja transakcja = new Transakcja(data, miasto, sklep, kategoria, towar, cena, sztuk);
				lista.add(transakcja);
			}
		}
		return lista;
	}

	public static void main(String[] args) {
		Pomiary.wypiszPamiec();
		Opakowanie<List<Transakcja>> wynik = Opakowanie.empty();

		System.out.println("\nczytam");
		File plik = new File(WyczarujPliki.DUZY_PLIK);

		Pomiary.zmierzCzasDzalania(() -> {
			try {
				List<Transakcja> lista = wczytaj(plik);
				wynik.set(lista); // aby GC nie usunął listy
				System.out.println("Wczytano " + lista.size());
			} catch (IOException e) {
				e.printStackTrace();
			}
		});
		Pomiary.wypiszPamiec();

		System.out.println("\ngc");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
		System.out.println(wynik.get().size());
	}

}
