package p05_interfejsy;

import java.time.LocalDateTime;

public class Wielodziedziczenie {
    // Żeby wszystko było w jednym pliku, definiuję interfejsy i klasy jako elementy statyczne w tej klasie.

    interface A {
        void aaa();

        default void ccc() {
            System.out.println("A.ccc");
        }

        static String wizytowka() {
            return "wynik statyczny";
        }

        String poleStatyczne = "to jest wartość pola w intefejsie A";
        // wszystkie pola w interfejsie są public static final
        // ale to nie zawsze oznacza "prawdziwą stałą" (którą kompilator mógłby "zinlajnować")
        String czas = LocalDateTime.now().toString();
    }

    interface B {
        default void aaa() {
            System.out.println("B.aaa");
        }

        default void bbb() {
            System.out.println("B.bbb");
        }

        default void ccc() {
            System.out.println("B.ccc");
        }
    }

    static class Klasa1 implements A, B {
        static int czas = 1234;

        @Override
        public void aaa() {
            System.out.println("Klasa1.aaa");
        }

        @Override
        public void ccc() {
            // aby wywołać implementację odziedziczoną z interfejsu, notaca jest taka:
            A.super.ccc();
            B.super.ccc();
            System.out.println("Klasa1.ccc");
            // System.out.println(A.super.czas);
            // System.out.println(super.czas);
            System.out.println(A.czas);
        }
    }

    static void main() {
        Klasa1 obiekt1 = new Klasa1();
        obiekt1.aaa();
        obiekt1.bbb();
        System.out.println();
        obiekt1.ccc();
        System.out.println();

        System.out.println(A.wizytowka());
        // System.out.println(Klasa1.wizytowka());

        System.out.println(A.poleStatyczne);
        System.out.println(Klasa1.poleStatyczne);

        System.out.println(A.czas);
        System.out.println(Klasa1.czas);
    }
}
