package sprzedaz.wydajnosc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import sprzedaz.Transakcja;

// Zamiast zwykłej HashMap, używamy wersji ConcurrentHashMap,
// aby przygotować się do zrównoleglenia procesu wczytywania w ramach "MaszynaWczytujaca2".
// Używam też nowej operacji do "leniwej inicjalizacji" słowników - computeIfAbsent.
public class WczytajSprzedaz6 {

	static List<Transakcja> wczytaj(File plik) throws IOException {
		Map<String, LocalDate> pulaDat = new ConcurrentHashMap<>();
		Map<String, BigDecimal> pulaCen = new ConcurrentHashMap<>();

		List<Transakcja> lista = new ArrayList<>();
		try(BufferedReader reader = Files.newBufferedReader(plik.toPath())) {
			String linia = reader.readLine();
			while ((linia = reader.readLine()) != null) {
				String[] pola = linia.split(",");
				int sztuk = Integer.parseInt(pola[6]);

				LocalDate data = pulaDat.computeIfAbsent(pola[0], LocalDate::parse);
				BigDecimal cena = pulaCen.computeIfAbsent(pola[5], BigDecimal::new);

				String miasto = pola[1].intern();
				String sklep = pola[2].intern();
				String kategoria = pola[3].intern();
				String towar = pola[4].intern();

				Transakcja transakcja = new Transakcja(data, miasto, sklep, kategoria, towar, cena, sztuk);
				lista.add(transakcja);
			}
		}
		return lista;
	}

	public static void main(String[] args) {
		Pomiary.wypiszPamiec();
		Opakowanie<List<Transakcja>> wynik = Opakowanie.empty();

		System.out.println("\nczytam");
		File plik = new File(WyczarujPliki.DUZY_PLIK);

		Pomiary.zmierzCzasDzalania(() -> {
			try {
				List<Transakcja> lista = wczytaj(plik);
				wynik.set(lista); // aby GC nie usunął listy
				System.out.println("Wczytano " + lista.size());
			} catch (IOException e) {
				e.printStackTrace();
			}
		});
		Pomiary.wypiszPamiec();

		System.out.println("\ngc");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
		System.out.println(wynik.get().size());
	}

}
