package pan_tadeusz;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.List;

public class P14_PosortujLinieStream {

    public static void main(String[] args) {
        try {
            System.out.println("Startujemy...");
            List<String> sorted = Files.lines(Paths.get("pan_tadeusz.txt"), Charset.forName("UTF-8"))
                .filter(line -> !line.isBlank())
                .map(String::strip)
                .sorted(Collator.getInstance())
                .toList(); // od Java 16; w starszych trzeba .collect(Collectors.toList())

            System.out.println("Zapisywanie...");
            Files.write(Paths.get("posortowany4.txt"), sorted);
            System.out.println("Gotowe.");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
