package pan_tadeusz;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class P06_PoliczKazdeSlowo_v2 {

    public static void main(String[] args) {
        System.out.println("Startujemy");
        // Map<String, Integer> slowa = new HashMap<>();
        Map<String, Integer> slowa = new TreeMap<>(Collator.getInstance(Locale.of("pl", "PL")));

        try(Scanner scanner = new Scanner(new File("pan_tadeusz.txt"))) {
            scanner.useDelimiter("[^\\p{L}\\d]+");
            while(scanner.hasNext()) {
                String slowo = scanner.next().toLowerCase();
                int ileBylo = slowa.getOrDefault(slowo, 0);
                slowa.put(slowo, ileBylo+1);
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

        // System.out.println(slowa);
        for(var entry : slowa.entrySet()) {
            System.out.printf("%-20s : %5d\n", entry.getKey(), entry.getValue());
        }
    }

}
