package p15_kolekcje.z_zbierz_dane;

import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;

// - TreeSet przechowuje elementy w kolejności posortowanej
public class P5_TreeSet {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        Set<String> zbior = new TreeSet<>();

        // Jeśli ma zawierać od razu elementy, to od Javy 9 pisze się tak:
        // Set<String> zbior = new TreeSet<>(Set.of("Ala", "Ela", "Ola"));

        while(true) {
            System.out.print("Podaj kolejne imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            zbior.add(imie);
        }

        System.out.println("Liczba elementów: " + zbior.size());
        System.out.println("Wszystkie imiona:");
        System.out.println(zbior);

        // Tablica i wszystkie typy kolekcji pozwalają na używanie pętli "for-each".
        for(String imie : zbior) {
            System.out.print("; witaj " + imie);
        }
        System.out.println();

        // Drugi etap: użytkownik podaje imię, a program sprawdza, czy takie imię istnieje.
        // To jest najbardziej podstawowa operacja dla zbiorów.
        // Niezależnie od implementacji ta operacja działa szybko (chociaż dla dużych zbiorów wersje Hash są trochę szybsze niż Tree)
        while(true) {
            System.out.print("Podaj imię: ");
            // pusty string kończy
            String imie = scanner.nextLine();
            if(imie.isEmpty()) {
                break;
            }
            if(zbior.contains(imie)) {
                System.out.println("TAK");
            } else {
                System.out.println("NIE");
            }
            // to nie Java: if(imie in zbior)
        }

    }

}
