package emps.v2_obiektowo;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie3 {
	// W tej wersji używam operacji putIfAbsent / computeIfPresent (można też użyć compute)

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		Map<String, Integer> sumy = new TreeMap<>();
		Map<String, Integer> ilosci = new TreeMap<>();

		for(Employee emp : emps) {
			// co wstawić w razie braku danych (gdy dane już są - krok jest pomijany)
			sumy.putIfAbsent(emp.getJobTitle(), 0);
			// w jaki sposób uzyskuje się nową wartość na podstawie klucza oraz starej wartości
			sumy.computeIfPresent(emp.getJobTitle(), (job, staraSuma) -> staraSuma + emp.getSalary());

			ilosci.putIfAbsent(emp.getJobTitle(), 0);
			ilosci.computeIfPresent(emp.getJobTitle(), (job, staraIlosc) -> staraIlosc + 1);
		}

		sumy.keySet().forEach(job -> {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |%n", job, ile, srednia);
		});
	}

}
