package p02_obiekty;

public class Konto {
    private final int numer;
    private int saldo;
    private Osoba wlasciciel;

    public Konto(int numer, int saldo, Osoba wlasciciel) {
        if(saldo < 0) {
            throw new IllegalArgumentException("ujemne saldo!");
        }
        this.numer = numer;
        this.saldo = saldo;
        this.wlasciciel = wlasciciel;
    }

    public int getNumer() {
        return numer;
    }

    public int getSaldo() {
        return saldo;
    }

    public Osoba getWlasciciel() {
        return wlasciciel;
    }

    public void setWlasciciel(Osoba wlasciciel) {
        this.wlasciciel = wlasciciel;
    }

    @Override
    public String toString() {
        return "Konto nr " + numer + ", saldo " + saldo + ", wł. " + wlasciciel;
    }

    public void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota wpłaty nie jest dodatnia");
        }
        saldo += kwota;
        // aby zabezpieczyć się przed IntegerOveflow,
        // można by użyć saldo = Math.addExact(saldo, kwota);
    }

    public void wyplata(int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota wypłaty nie jest dodatnia");
        }
        if(kwota > saldo) {
            throw new BrakSrodkow("Za mało kasy");
        }
        saldo -= kwota;
    }
    
    public void przelew(Konto inne, int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota przelewu nie jest dodatnia");
        }
        if(kwota > saldo) {
            throw new BrakSrodkow("Za mało kasy");
        }
        this.saldo -= kwota;
        inne.saldo += kwota;
    }
}
