package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import static java.util.stream.Collectors.*;

public class Grupowanie5 {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		Map<String, BigDecimal> sumy = lista.stream()
				.collect(groupingBy(Rekord::getMiasto,
						mapping(Rekord::getWartosc,
								reducing(BigDecimal.ZERO, BigDecimal::add))));
		
		sumy.forEach((miasto, srednia) -> System.out.printf("%-10s → %12s%n", miasto, srednia));
	}

}
