package sklep;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Scanner;

public class Sklep3 {
	private static final String NAZWA_PLIKU = "sklep.csv";

	public static void main(String[] args) {
		System.out.println("Wczytuję dane...");
		Map<String, Towar> towary = Towar.wczytajPlik(NAZWA_PLIKU);
		
		System.out.println("Dostępne towary:");

		wypiszTowary(towary);
		
		Scanner scanner = new Scanner(System.in);
		BigDecimal suma = BigDecimal.ZERO;
		while(true) {
			System.out.println("Co chcesz kupić? (podaj nazwę towaru lub pusty napis, aby zakończyć)");
			String coKupuje = scanner.nextLine();
			if(coKupuje.isEmpty())
				break;
			Towar towar = towary.get(coKupuje);
			if(towar == null) {
				System.out.println("Nie ma takiego towaru");
				System.out.println("Dostepne towary: " + towary.keySet());
				continue;
			}
			System.out.println("Jedna sztuka kosztuje " + towar.getCenaBrutto() + ". Ile sztuk chcesz kupić?");
			int ileSztuk = scanner.nextInt();
			scanner.nextLine();
			if(ileSztuk > towar.getStan()) {
				System.out.println("Za mało sztuk w magazynie, mamy tylko " + towar.getStan());
				continue;
			}
			BigDecimal doZaplaty = towar.getCenaBrutto().multiply(BigDecimal.valueOf(ileSztuk));
			System.out.println("Za " + ileSztuk + " towaru " + coKupuje + " zapłacisz " + doZaplaty);
			suma = suma.add(doZaplaty);
			towar.zmiejszStan(ileSztuk);
		}
		
		System.out.println("W sumie do zapłaty: " + suma);
		System.out.println();
		
		System.out.println("Końcowy stan sklepu:");
		
		wypiszTowary(towary);
		
		System.out.println("Zapisuję zmiany do pliku");
		Towar.zapiszPlik(towary, NAZWA_PLIKU);
		System.out.println("Koniec");
	}

	private static void wypiszTowary(Map<String, Towar> towary) {
		System.out.println("  --------------------");
		for (Towar towar : towary.values()) {
			System.out.printf("  |%-20s | %8s | %3d sztuk|\n", towar.getNazwa(), towar.getCenaBrutto(), towar.getStan());
		}
		System.out.println("  --------------------");
	}

}
