package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Grupowanie2 {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		Map<String, BigDecimal> slownik = new TreeMap<>();
		for(Rekord rekord : lista) {
			// Próbujemy oczytać wartość spod klucza, ale gdyby nie było, to pobierami domyślne ZERO
			BigDecimal suma = slownik.getOrDefault(rekord.getMiasto(), BigDecimal.ZERO);
			slownik.put(rekord.getMiasto(), suma.add(rekord.getWartosc()));
		}
		
		for(Map.Entry<String, BigDecimal> entry : slownik.entrySet()) {
			System.out.printf("%-10s → %12s%n", entry.getKey(), entry.getValue());
		}
	}

}
