package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

// Klasyczny algorytm grupowania z wykorzystaniem słowników.
// Używamy tylko operacji dostępnych w Javie 5-7.
public class Grupowanie1 {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		// W słowniku dla danego miasta pamiętamy sumę wartości.
		// Słownik jest uzupełniany w trakcie czytania listy.
		Map<String, BigDecimal> slownik = new TreeMap<String, BigDecimal>();
		for(Rekord rekord : lista) {
			String miasto = rekord.getMiasto();
			if(slownik.containsKey(miasto)) {
				// to jest kolejny rekord z miasta, które ju było → zwiększamy sumę
				BigDecimal suma = slownik.get(miasto);
				slownik.put(miasto, suma.add(rekord.getWartosc()));
			} else {
				// to jest pierwszy rekord z danego miasta → dodaję pierwszy wpis
				slownik.put(miasto, rekord.getWartosc());
			}
		}
		
		// System.out.println(slownik);
		// Przejrzenie zawartości słownika - kluczy wraz z wartościami
		// Wersja dla Javy < 8 oparta o entrySet. Entry to jest para klucz→wartość
		for(Map.Entry<String, BigDecimal> entry : slownik.entrySet()) {
			System.out.printf("%-10s → %12s%n", entry.getKey(), entry.getValue());
		}
	}

}
