package sprzedaz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

// Celem programów z tej serii jest obliczenie sumy sprzedaży w każdym mieści, jakie występuje w pliku.
// Odpowiada to operacji GROUP BY z języka SQL.

// W tej wersji rozwiązanie nie jest optymalne zwn wydajność.
// Wielokrotnie przeglądam dane źródłowe: raz, aby ustalić, jakie są miasta, a później dla każdego miasta, aby przefiltrować i zsumować.

public class Grupowanie0 {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		// etap 1: przeglądają całą listę zbieramy informacje o tym, jakie występują miasta
		Set<String> miasta = new TreeSet<>();
		for(Rekord rekord : lista) {
			miasta.add(rekord.getMiasto());
		}
		System.out.println("Miasta: " + miasta);
		
		// etap 2:
		for(String miasto : miasta) {
			BigDecimal suma = BigDecimal.ZERO;
			for(Rekord rekord : lista) {
				if(rekord.getMiasto().equals(miasto)) {
					suma = suma.add(rekord.getWartosc());
				}
			}
			System.out.printf("%-10s → %12s%n", miasto, suma);
		}

	}

}
