package p08_enkapsulacja;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Student extends Osoba {
	private String kierunek;
	private int rok;
	private final List<Integer> oceny = new ArrayList<>();
	
	public Student() {
	}
	
	public Student(String imie, String nazwisko, int wiek, String kierunek, int rok) {
		super(imie, nazwisko, wiek);
		this.kierunek = kierunek;
		this.rok = rok;
	}

	public void dodajOcene(int ocena) {
		if(ocena < 2 || ocena > 5) {
			throw new IllegalArgumentException("ocena poza zakresem");
		}
		oceny.add(ocena);
	}
	
	public double sredniaOcen() {
		double suma = 0;
		for(int ocena : oceny) {
			suma += ocena;
		}
		return suma / oceny.size();
	}
	
	@Override
	public void przedstawSie() {
		System.out.println("Hej, tu " + getImie() + " " + getNazwisko() + ", studiuję kierunek " + kierunek + " na " + rok + " roku");
	}

	@Override
	public String toString() {
		return super.toString() + ", student " + rok + " roku kierunku " + kierunek ;
	}
	
	public String getKierunek() {
		return kierunek;
	}
	
	public int getRok() {
		return rok;
	}
	
	public List<Integer> getOceny() {
		return Collections.unmodifiableList(oceny);
	}
}
