package p06_klasy_podstawy.v3;

import java.util.ArrayList;
import java.util.List;

public class Student extends Osoba {
	int rok;
	String kierunek;
	List<Integer> oceny = new ArrayList<>();
	
	// W Javie konstruktory nie są dziedziczone z nadklasy,
	// ale w podklasie można stworzyć konstruktor, który wywołuje konstruktor nadklasowy za pomocą super().
	public Student(String imie, String nazwisko, int wiek, int rok, String kierunek) {
		super(imie, nazwisko, wiek);
		this.rok = rok;
		this.kierunek = kierunek;
	}
	
	void dodajOcene(int ocena) {
		oceny.add(ocena);
	}
	
	double sredniaOcen() {
		double suma = 0;
		for(int ocena : oceny) {
			suma += ocena;
		}
		return suma / oceny.size();
	}

	double sredniaOcenStream() {
		return oceny.stream().mapToInt(Integer::intValue).average().orElse(Double.NaN); // albo 0
	}

	void przedstawSie() {
		System.out.println("Hejka " + imie);
	}
	
}
