package emps;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;

import javax.swing.JOptionPane;

public class F7b_MinMax_Filter {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		String szukanyJob = JOptionPane.showInputDialog("Podaj nazwę stanowiska");
		if(szukanyJob == null) {
			return;
		}
		
		String message1 = emps.stream()
			.filter(emp -> Objects.equals(emp.getJobTitle(), szukanyJob))
			.max(Comparator.comparingInt(Employee::getSalary))
			.map(emp -> emp.getFirstName() + " " + emp.getLastName() + " z pensją " + emp.getSalary())
			.orElse("nikogo nie znaleziono");
		
		JOptionPane.showMessageDialog(null, "Najwięcej zarabia: " + message1);

		String message2 = emps.stream()
				.filter(emp -> Objects.equals(emp.getJobTitle(), szukanyJob))
				.min(Comparator.comparingInt(Employee::getSalary))
				.map(emp -> emp.getFirstName() + " " + emp.getLastName() + " z pensją " + emp.getSalary())
				.orElse("nikogo nie znaleziono");
			
		JOptionPane.showMessageDialog(null, "Najmniej zarabia: " + message2);
	}

}
