package emps;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class F7_MinMax {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// Znalezienie samej maksymalnej liczby
		emps.stream()
			.mapToInt(Employee::getSalary)
			.max()
			.ifPresent(System.out::println);

		// Znalezienie obiektu
		Optional<Employee> max = emps.stream()
			.max(Comparator.comparingInt(Employee::getSalary));

		Optional<Employee> min = emps.stream()
			.min(Comparator.comparingInt(Employee::getSalary));

		if(max.isPresent()) {
			System.out.println("Najwięcej zarabia: " + max.get());
		}

		if(min.isPresent()) {
			System.out.println("Najwięcej zarabia: " + min.get());
		}
		
	}

}
