package emps;

import java.io.File;
import java.util.List;
import java.util.OptionalDouble;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class F6b_SredniaWybranychInteraktywnie {

	public static void main(String[] args) {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setFileFilter(new FileNameExtensionFilter("pliki CSV", "csv", "txt"));
		int coSieStalo = chooser.showOpenDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			// jeśli było Cancel lub wystąpił błąd
			return;
		}
		File plik = chooser.getSelectedFile();
		List<Employee> emps = ObslugaCSV.wczytaj(plik);
		
		Object[] jobs = emps.stream()
			.map(Employee::getJobTitle)
			.distinct()
			.sorted()
			.toArray();
		
		Object szukanyJob = JOptionPane.showInputDialog(null, "Wybierz stanowisko",
				"Pytanie", JOptionPane.QUESTION_MESSAGE, null, jobs, null);
		
		if(szukanyJob == null) {
			return;
		}
		
		OptionalDouble avg = emps.stream()
				.filter(emp -> szukanyJob.equals(emp.getJobTitle()))
				.mapToInt(Employee::getSalary)
				.average();
		
		if(avg.isPresent()) {
			JOptionPane.showMessageDialog(null, "Średnia wynosi " + avg.getAsDouble());
		} else {
			JOptionPane.showMessageDialog(null, "Nikt nie pracuje na takim stanowisku", "Brak danych", JOptionPane.WARNING_MESSAGE);
		}

	}

}
