package emps;

import java.util.List;
import java.util.stream.Collectors;

public class F4_SredniaWszystkich {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");

		double avg = emps.stream() //
				.mapToInt(Employee::getSalary) // równoważne lambdzie: emp -> emp.getSalary()
				.average() //
				.orElse(0.0); //
		System.out.println(avg);

		double avg2 = emps.stream().collect(Collectors.averagingInt(Employee::getSalary));
		System.out.println(avg2);

	}

}

// ZADANIE
// Program F5_SredniaProgramistow - oblicza średnią pensję na stanowisku Programmer
// F6_SredniaWybranych - użytkownik podaje nazwę stanowiska, a program oblicza średnią na tym stanowisku
