package sprzedaz;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class Rekord {
	private LocalDate data;
	private String miasto;
	private String sklep;
	private String kategoria;
	private String towar;
	private BigDecimal cena;
	private int sztuk;
	
	public Rekord(LocalDate data, String miasto, String sklep, String kategoria, String towar, BigDecimal cena, int sztuk) {
		this.data = data;
		this.miasto = miasto;
		this.sklep = sklep;
		this.kategoria = kategoria;
		this.towar = towar;
		this.cena = cena;
		this.sztuk = sztuk;
	}

	public LocalDate getData() {
		return data;
	}

	public String getMiasto() {
		return miasto;
	}

	public String getSklep() {
		return sklep;
	}

	public String getKategoria() {
		return kategoria;
	}

	public String getTowar() {
		return towar;
	}

	public BigDecimal getCena() {
		return cena;
	}

	public int getSztuk() {
		return sztuk;
	}

	@Override
	public String toString() {
		return "Rekord [data=" + data + ", miasto=" + miasto + ", sklep=" + sklep + ", kategoria=" + kategoria
				+ ", towar=" + towar + ", cena=" + cena + ", sztuk=" + sztuk + "]";
	}

	@Override
	public int hashCode() {
		return Objects.hash(cena, data, kategoria, miasto, sklep, sztuk, towar);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Rekord other = (Rekord) obj;
		return Objects.equals(cena, other.cena) && Objects.equals(data, other.data)
				&& Objects.equals(kategoria, other.kategoria) && Objects.equals(miasto, other.miasto)
				&& Objects.equals(sklep, other.sklep) && sztuk == other.sztuk && Objects.equals(towar, other.towar);
	}
	
	
	
}
