package sklep;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Scanner;

public class Sklep2 {

	public static void main(String[] args) {
		// W tej wersji program na początku wczytuje dane z pliku,
		// następnie pozwala kupić wybrane produkty z różnej liczbie
		// (wylicza kwotę do zapłaty i zmniejsza stany magazynowe)
		// a na końcu zapisuje do pliku zmienione dane.
		
		System.out.println("Wczytuję dane...");
		Map<String, Towar> towary = Towar.wczytajPlik("sklep.csv");
		
		System.out.println("Dostępne towary:");
//		for (Map.Entry<String, Towar> entry : towary.entrySet()) {
//			System.out.println("    " + entry.getKey() + " za cenę " + entry.getValue().getCenaBrutto());
//		}

		// tutaj nie musimy przeglądać wartości wraz z kluczami, bo w obiektach Towar są wszystkie informacje,
		// wystarczy przeglądać wartości
		System.out.println("  --------------------");
		for (Towar towar : towary.values()) {
			System.out.printf("  |%-20s | %8s | %3d sztuk|\n", towar.getNazwa(), towar.getCenaBrutto(), towar.getStan());
		}
		System.out.println("  --------------------");
		
		Scanner scanner = new Scanner(System.in);
		// TODO pytaj użytkownika co chce kupić (użytkownik podaje nazwę) aż uzytkownik poda pusty napis - to oznacza koniec
		// zapytaj o liczbę sztuk
		// podaj kwotę do zapłaty za ten produkt
		
		// na końcu program ma wypisać sumaryczną kwotę do zapłaty
		BigDecimal suma = BigDecimal.ZERO;
		while(true) {
			System.out.println("Co chcesz kupić? (podaj nazwę towaru lub pusty napis, aby zakończyć)");
			String coKupuje = scanner.nextLine();
			if(coKupuje.isEmpty())
				break;
			Towar towar = towary.get(coKupuje);
			if(towar == null) {
				System.out.println("Nie ma takiego towaru");
				System.out.println("Dostepne towary: " + towary.keySet());
				continue;
			}
			System.out.println("Jedna sztuka kosztuje " + towar.getCenaBrutto() + ". Ile sztuk chcesz kupić?");
			int ileSztuk = scanner.nextInt();
			scanner.nextLine();
			if(ileSztuk > towar.getStan()) {
				System.out.println("Za mało sztuk w magazynie, mamy tylko " + towar.getStan());
				continue;
			}
			BigDecimal doZaplaty = towar.getCenaBrutto().multiply(BigDecimal.valueOf(ileSztuk));
			System.out.println("Za " + ileSztuk + " towaru " + coKupuje + " zapłacisz " + doZaplaty);
			suma = suma.add(doZaplaty);
			towar.zmiejszStan(ileSztuk);
		}
		
		System.out.println("W sumie do zapłaty: " + suma);
		System.out.println();
		
		System.out.println("Końcowy stan sklepu:");
		System.out.println("  --------------------");
		for (Towar towar : towary.values()) {
			System.out.printf("  |%-20s | %8s | %3d sztuk|\n", towar.getNazwa(), towar.getCenaBrutto(), towar.getStan());
		}
		System.out.println("  --------------------");
		
		System.out.println("Zapisuję zmiany do pliku");
		Towar.zapiszPlik(towary, "sklep.csv");
		System.out.println("Koniec");
	}

}
