package p02_teoria_zmiennych;

public class DeklaracjeZmiennych {

	public static void main(String[] args) {
		// Nie wolno używać zmiennych, które nie są zadeklarowane
		// x = 123;
		// System.out.println(x);
		
		// Sama deklaracja wygląda tak:
		int x;
		// teraz do takiej zmiennej mógłbym już wpisać wartość, ale nie mogę jej jeszcze czytać, bo jest niezainicjowana:
		// System.out.println(x);
		
		// Przypisanie wartości do zmiennej
		x = 345;
		System.out.println(x);

		// Wartość zmiennej można zmienić (o ile ta zmienna nie jest "final")
		x++; // zwiększenie liczby o 1
		System.out.println(x);
		
		x += 5; // zmiana względem poprzedniej wartości
		System.out.println(x);
		
		// wpisanie zupełnie innej wartości
		x = 200 * 4;
		System.out.println(x);
		System.out.println();
		
		int y;
		if(x > 100) {
			y = 333;
			System.out.println(y); // tutaj OK
		}
		// Kompilator myśli: "Gdyby program nie wszedł do if-a, to zmienna y nie byłaby zainicjowana".
		// I dlatego w tym miejscu jest zgłaszany błąd kompilacji.
		// System.out.println(y);
		
		if(x > 200) {
			y = 444;
		} else {
			y = 555;
		}
		// Ale teraz y na pewno ma jakąś wartość, więc ta linia jest OK:
		System.out.println(y);
		
		// W praktyce najczęściej deklarując zmienną od razu wpisuje się jej początkową wartość:
		double z = 321.123;
		System.out.println(z);
		
		// Wpisując inną wartość do już istniejącej zmiennej, nie podajemy jej typu:
		// double z = 321.123;
		// int x = 5432;
		x = 5432;
		System.out.println(x);
	}

}
