package p12_kolekcje.zbieranie_danych;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ZbieranieDanych7_HashMap {
    // Słowniki (mapy):
    // - zawierają pary klucz → wartość
	// - klucze nie mogą się powtarzać, wartości mogą
	// - wydajne są operacje dodawanie elementu i pobierania/wyszukiwania poprzez klucz
	// - niewydaje jest wyszukiwanie poprzez wartość

	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		// Przykładowo tutaj dla imienia (string) pamiętamy wiek (Integer)
		Map<String, Integer> slownik = new HashMap<>();
		
		while(true) {
			System.out.print("Podaj kolejne imię: ");
			String imie = scanner.nextLine();
			if(imie.isEmpty()) break;
			System.out.print("Ile lat ma ta osoba? ");
			int wiek = scanner.nextInt();
			scanner.nextLine();
			slownik.put(imie, wiek);
		}
		System.out.println(slownik);
		System.out.println();
		
		System.out.println("Podawaj imiona, aby sprawdzić, a zakończ pustym napisem.");
		while(true) {
            System.out.print("Podaj szukane imię: ");
            String szukane = scanner.nextLine();
            if(szukane.isEmpty()) break;
            if(slownik.containsKey(szukane)) {
            	int wiek = slownik.get(szukane);
            	System.out.println("Osoba " + szukane + " ma " + wiek + " lat.");
            } else {
                System.out.println("Osoba " + szukane + " nie należy do słownika.");
            }
		}
	}

}
