package p12_kolekcje.zbieranie_danych;

import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class ZbieranieDanych5_HashSet {
    // Zbiory:
    // - nie zawierają duplikatów (dodanie kolejny raz tej samej wartości nie zmienia już zbioru),
    // - mają prawo zmienić kolejność elementów
    //   → HashSet zmienia kolejność
    //   → LinkedHashSet nie zmienia kolejności (zachowuje początkową kolejność, w jakiej elementy były dodawane)
    //   → TreeSet samoczynnie sortuje elementy
    // Podstawową (i wydajną) operacją dla zbioru jest sprawdzenie czy element należy do zbioru.

	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		Set<String> zbior = new HashSet<>();
		
		System.out.println("Podawaj imiona, a zakończ pustym napisem (ENTER)");
		while(true) {
			System.out.print("Podaj kolejne imię: ");
			String imie = scanner.nextLine();
			if(imie.isEmpty()) break;
			zbior.add(imie);
		}
		System.out.println(zbior);
		System.out.println();
		
		System.out.println("Podawaj imiona, aby sprawdzić, a zakończ pustym napisem.");
		while(true) {
            System.out.print("Podaj szukane imię: ");
            String szukane = scanner.nextLine();
            if(szukane.isEmpty()) break;
            if(zbior.contains(szukane)) {
            	 System.out.println("Imię " + szukane + " należy do zbioru");
            } else {
                System.out.println("Imię " + szukane + " nie należy do zbioru");
            }
		}
	}

}
