package sprzedaz;

import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie7 {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		Map<String, DoubleSummaryStatistics> srednie = lista.stream()
				.collect(Collectors.groupingBy(Rekord::getMiasto,
						Collectors.summarizingDouble(Rekord::getWartoscDouble)));
		
		srednie.forEach((miasto, stats) -> System.out.printf("| %-32s | %2d | %8.2f | %8.2f | %8.2f | %12.2f |%n",
				miasto, stats.getCount(), stats.getMin(), stats.getAverage(), stats.getMax(), stats.getSum()));
	}

}
