package sprzedaz;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie6 {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		Map<String, Double> srednie = lista.stream()
				.collect(Collectors.groupingBy(Rekord::getMiasto,
						Collectors.averagingDouble(Rekord::getWartoscDouble)));
		
		srednie.forEach((miasto, srednia) -> System.out.printf("%-10s → %8.2f%n", miasto, srednia));
	}

}
