package sprzedaz_rekordy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class P2_SredniaWartosc {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		// oblicz średnią wartość transakcji

		// styl "imperatywny"
		// gdybyśmy mieli tylko metodę zwracającą cenę jako BigDecimal i chcieli liczcyć na BigDecimalach:
		BigDecimal suma = BigDecimal.ZERO;
		for(Rekord rekord : lista) {
			// add działa jak +   a nie jak +=
			suma = suma.add(rekord.cena().multiply(BigDecimal.valueOf(rekord.sztuk())));
		}
		System.out.println("suma: " + suma);
		BigDecimal sredniaBD = suma.divide(BigDecimal.valueOf(lista.size()), 2, RoundingMode.HALF_EVEN);
		System.out.println("średnia BD: " + sredniaBD);

		// Do klasy Rekord można dodać metody, które "wyglądają jak gettery",
		// ale obliczają swoje wyniki na podstawie innych pól obiektu.
		// Ma to sens, jeśli danej operacji potrzebujemy często, w różnych miejscach kodu.
		
		double sumaDouble = 0.0;
		for(Rekord rekord : lista) {
			sumaDouble += rekord.getWartoscDouble();
		}
		double sredniaDouble = sumaDouble / lista.size();
		System.out.println("średnia  D: " + sredniaDouble);
		
		// wersja funkcyjna:
		double sredniaStream = lista.stream().mapToDouble(Rekord::getWartoscDouble).average().orElse(0.0);
		System.out.println("średnia  S: " + sredniaStream);

		double sredniaPStream = lista.parallelStream().mapToDouble(Rekord::getWartoscDouble).average().orElse(0.0);
		System.out.println("średnia  P: " + sredniaPStream);
		
	}

}
