package sprzedaz;

import java.math.BigDecimal;
import java.util.List;

import javax.swing.JOptionPane;

public class P3_SumaWMiescie {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		String miasto = JOptionPane.showInputDialog("Podaj miasto");
		
		// getMiasto nie zwraca nigdy null
		// wersja double:
		double suma1 = lista.stream()
			.filter(r -> r.getMiasto().equalsIgnoreCase(miasto))
			.mapToDouble(Rekord::getWartoscDouble)
			.sum();
		
		// wersja BigDecimal:
		BigDecimal suma2 = lista.stream()
			.filter(r -> r.getMiasto().equalsIgnoreCase(miasto))
			.map(Rekord::getWartosc)
			.reduce(BigDecimal.ZERO, BigDecimal::add);
		
		JOptionPane.showMessageDialog(null, "Suma double: " + suma1 + "\nSuma BigDecimal: " + suma2);
	}

}
