package sprzedaz;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Grupowanie4 {

	public static void main(String[] args) {
		List<Rekord> lista = ObslugaCSV.wczytaj("sprzedaz.csv");
		
		// Tutaj stosujemy Collectors.groupingBy w najprosztszej wersji - grupowanie rekordów.
		// Powstaje słownik, gdzie dla określonego klucza (np. miasta Katowice)
		// wartością jest lista tych rekordów, które należą do tej grupy.
		Map<String, List<Rekord>> grupy = lista.stream().collect(Collectors.groupingBy(Rekord::getMiasto));
		System.out.println("Liczba grup: " + grupy.size());
		System.out.println("Klucze: " + grupy.keySet());
		
		// Tutaj dla każdego miasta zapiszemy sobie plik z transakcjami z tego miasta
		// Przeglądanie danych też zapiszemy "funkcyjnie" - od Javy 8 można tak:
		
		grupy.forEach((miasto, rekordy) -> {
			System.out.println("W mieście " + miasto + " było " + rekordy.size() + " transakcji");
			List<String> lines = rekordy.stream().map(Rekord::toString).collect(Collectors.toList());
			try {
				Files.write(Paths.get("rekordy_" + miasto + ".txt"), lines, StandardOpenOption.CREATE);
			} catch (IOException e) {
				System.err.println(e);
			}
		});
		System.out.println("Gotowe");
	}

}
