package p12_kolekcje.zbieranie_danych;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Scanner;

public class ZbieranieDanych3_Queue {
	// Kolejka to struktura danych zoptymalizowana pod kątem dostępu do "następnego elementu"
	// (operacja poll() lub get()).
	// * Kolejka prosta zachowuje kolejność elementów i następnym elementem do pobrania jest ten,
	//   który został najdawniej w kolejce umieszczony.
	//   Jak "sprawiedliwa" kolejna do kasy w sklepie.
	//   Najczęściej jest to jednocześnie kolejka dwukońcowa (Dequeue) z możliwością dostepu do obu jej końców.

	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		
		Queue<String> kolejka = new LinkedList<>(); // albo ArrayDequeue; - to są "kolejki proste"
		System.out.println(kolejka);
		System.out.println("Podawaj kolejne elementy, aby dodać do kolejki.\nWpisz '?', aby pobrać element z kolejki, a Enter aby zakończyć program");
		
		while(true) {
			System.out.println("Kolejka: " + kolejka);
			System.out.print("> ");
			String napis = scanner.nextLine();
			if(napis.isEmpty()) break;
			if(napis.equals("?")) {
				String pobrane = kolejka.poll();
				System.out.println("Pobrany element: " + pobrane);
			} else {
				System.out.println("Dodany element: " + napis);
				kolejka.add(napis);
			}
		}
		
		System.out.println("Końcowy rozmiar kolejki " + kolejka.size());
		System.out.println(kolejka);
		System.out.println("Koniec programu");
	}

}
