package p08_enkapsulacja;

import java.math.BigDecimal;

class Pracownik extends Osoba {
	private String zawod;
	private BigDecimal pensja;

	Pracownik() {
		
	}

	Pracownik(String imie, String nazwisko, int wiek, String zawod, BigDecimal pensja) {
		// wywołanie konstruktora z nadklasy
		super(imie, nazwisko, wiek);
		this.zawod = zawod;
		this.pensja = pensja;
	}

	Pracownik(String imie, String nazwisko, int wiek, String zawod, double pensja) {
		// wywołanie innego konstruktora z tej samej klasy
		this(imie, nazwisko, wiek, zawod, BigDecimal.valueOf(pensja).setScale(2));
	}
	
	Pracownik(String imie, String nazwisko, int wiek, String zawod, int pensja) {
		this(imie, nazwisko, wiek, zawod, BigDecimal.valueOf(pensja).setScale(2));
	}

	Pracownik(String imie, String nazwisko, int wiek, String zawod, String pensja) {
		this(imie, nazwisko, wiek, zawod, new BigDecimal(pensja));
	}

	// tworzenie wielu konstruktorów w tej samej klasie to jest "przeciążanie konstruktorów" / "overloading"
	
	@Override
	public void przedstawSie() {
		System.out.println("Dzień dobry, tu "+ getImie() + ", pracuję jako " + zawod + " i zarabiam " + pensja +" zł.");
	}
	
	public BigDecimal getPensja() {
		return pensja;
	}
	
	public String getZawod() {
		return zawod;
	}

}