package p08_enkapsulacja;

public class Konto {
	private final int numer;
	private int saldo;
	private Osoba wlasciciel;
	
	public Konto(int numer, int saldo, Osoba wlasciciel) {
		if(saldo < 0) {
			throw new IllegalArgumentException("Saldo nie może być ujemne");
		}
		this.numer = numer;
		this.saldo = saldo;
		this.wlasciciel = wlasciciel;
	}

	@Override
	public String toString() {
		return "Konto nr " + numer + ": " + saldo + " PLN , wł.: " + wlasciciel;
	}
	
	// Tylko dla pole wlasciciel pozwalamy na zmianę wartości.
	// Nie tworzymy setterów dla pól:
	// - numer - ponieważ numer nie będzie się zmieniać (w konkretnym obiekcie)
	//           dodatkowym podkreśleniem tego faktu i zabezpieczeniem przed własnymi błędami
	//           jest dopisanie final do pola numer
	// - saldo - ponieważ zmiana salda ma być możliwa tylko za pośrednictwem "metod biznesowych" wpłata, wypłata, przelew
	
	// Odpowiednie kontrolując wartości w tych metodach może zapewnić "niezmiennik" (invariant),
	// że saldo nigdy nie jest ujemne.
	// Zagadka: czy na pewno nie może?... :-)
	
	public int getNumer() {
		return numer;
	}
	
	public Osoba getWlasciciel() {
		return wlasciciel;
	}

	public void setWlasciciel(Osoba wlasciciel) {
		this.wlasciciel = wlasciciel;
	}

	public int getSaldo() {
		return saldo;
	}

	public void wplata(int kwota) {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Niedodatnia kwota wpłaty");
		}
		saldo += kwota;
		
		// aby uniknąć integer overflow, można tak:
		// saldo = Math.addExact(saldo, kwota);
	}

	public void wyplata(int kwota) throws BrakSrodkow {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Niedodatnia kwota wypłaty");			
		}
		if(kwota > saldo) {
			throw new BrakSrodkow("Niewystarczające środki na koncie nr " + numer);			
		}
		saldo -= kwota;
	}
	
	public void przelew(Konto kontoDocelowe, int kwota) throws BrakSrodkow {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Niedodatnia kwota przelewu: " + kwota);
		}
		if(kwota > saldo) {
			throw new BrakSrodkow("Za mało kasy na koncie nr " + numer);
		}		
		this.saldo -= kwota;
		kontoDocelowe.saldo += kwota;
		// Obiekt ma dostęp do pola prywatnego innego obiektu tej samej klasy!
	}
	
}
