package emps;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

import javax.swing.JOptionPane;

public class F7c_MinMax {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		String szukanyJob = JOptionPane.showInputDialog("Podaj nazwę stanowiska");
		if(szukanyJob == null) {
			return;
		}
		
		Predicate<Employee> warunek = emp -> Objects.equals(emp.getJobTitle(), szukanyJob);
		Function<Employee, String> opisPracownika = emp -> emp.getFirstName() + " " + emp.getLastName() + " z pensją " + emp.getSalary();

		String message1 = emps.stream()
			.filter(warunek)
			.max(Comparator.comparingInt(Employee::getSalary))
			.map(opisPracownika)
			.orElse("nikogo nie znaleziono");
		
		JOptionPane.showMessageDialog(null, "Najwięcej zarabia: " + message1);

		String message2 = emps.stream()
			.filter(warunek)
			.min(Comparator.comparingInt(Employee::getSalary))
			.map(opisPracownika)
			.orElse("nikogo nie znaleziono");
			
		JOptionPane.showMessageDialog(null, "Najmniej zarabia: " + message2);
	}

}
