package emps;

import java.util.List;
import java.util.OptionalDouble;

import javax.swing.JOptionPane;

public class F6a_SredniaWybranych {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		String szukanyJob = JOptionPane.showInputDialog("Podaj nazwę stanowiska");
		if(szukanyJob == null) {
			return;
		}
		
		OptionalDouble avg = emps.stream()
				.filter(emp -> szukanyJob.equalsIgnoreCase(emp.getJobTitle()))
				.mapToInt(Employee::getSalary)
				.average();
		
		if(avg.isPresent()) {
			JOptionPane.showMessageDialog(null, "Średnia wynosi " + avg.getAsDouble());
		} else {
			JOptionPane.showMessageDialog(null, "Nikt nie pracuje na takim stanowisku", "Brak danych", JOptionPane.WARNING_MESSAGE);
		}

	}

}
