package emps;

import java.io.File;
import java.io.FileNotFoundException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

// Klasa narzędziowa / utility class
// Jest to zestaw metod statycznych. Jak moduł w Pythonie czy C++.
public class ObslugaCSV {
	
	public static List<Employee> wczytaj(String sciezka) {
		List<Employee> emps = new ArrayList<>();
		// try with resources - od Java 7 - automatyczne zamykanie plików i innych zasobów
		try(Scanner scanner = new Scanner(new File(sciezka))) {
			scanner.nextLine(); // pomijamy pierwszą linię z nagłówkami
			while(scanner.hasNextLine()) {
				String linia = scanner.nextLine();
				String[] t = linia.split(";", -1);
				Employee emp = new Employee(Integer.parseInt(t[0]), t[1], t[2], t[3],
						Integer.parseInt(t[4]), LocalDate.parse(t[5]), t[6], t[7], t[8], t[9], t[10]);
//				if(java.util.concurrent.ThreadLocalRandom.current().nextDouble() < 0.1) {
//					emp.setJobTitle(null);
//				}
				emps.add(emp);
			}
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		return emps;
	}
	

}
